/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.Monitor;
import ibm.nways.jdm.snmp.AbstractSnmpPoller;
import ibm.nways.jdm.snmp.PollingInterval;
import ibm.nways.jdm.snmp.PollingIntervalAction;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.SwadeohPoller;
import java.util.Vector;

class PollerList {
    protected Vector pollers = new Vector();
    protected static final int NOT_PRESENT = -1;
    protected Monitor monitor;

    protected PollerList(Monitor monitor) {
        this.monitor = monitor;
    }

    protected void addPollerMonitor(PollingInterval pollingInterval, SnmpSession snmpSession) {
        if (this.findEntry(pollingInterval, snmpSession) == -1) {
            SwadeohPoller swadeohPoller = new SwadeohPoller(pollingInterval, (PollingIntervalAction)this.monitor);
            snmpSession.add((AbstractSnmpPoller)swadeohPoller, (Object)swadeohPoller);
            this.pollers.addElement(new SessionAndInterval(pollingInterval, snmpSession));
        }
    }

    protected void removePollerMonitor(PollingInterval pollingInterval, SnmpSession snmpSession) {
        int n = this.findEntry(pollingInterval, snmpSession);
        if (n != -1) {
            this.pollers.removeElementAt(n);
        }
    }

    private int findEntry(PollingInterval pollingInterval, SnmpSession snmpSession) {
        int n = -1;
        int n2 = this.pollers.size();
        int n3 = 0;
        while (n3 < n2) {
            SessionAndInterval sessionAndInterval = (SessionAndInterval)this.pollers.elementAt(n3);
            if (sessionAndInterval.isEqual(pollingInterval, snmpSession)) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    class SessionAndInterval {
        protected PollingInterval interval;
        protected SnmpSession session;

        protected SessionAndInterval(PollingInterval pollingInterval, SnmpSession snmpSession) {
            PollerList.this = PollerList.this;
            this.session = snmpSession;
            this.interval = pollingInterval;
        }

        protected boolean isEqual(PollingInterval pollingInterval, SnmpSession snmpSession) {
            return this.interval == pollingInterval && this.session == snmpSession;
        }
    }
}

